library(plyr)
library(reshape2)
library(ggplot2)
library(directlabels)
library(poLCA)

setwd("~/GitHub/hcistats/")
source("functions.r")
source("generate.r")

timepoints <- 3  # time in months

set.seed(11)
scale <- monthlySUSScaleData(base[base$Team=="Team B",]$ID, timepoints)  

# Change names
reg <- "^SUS(\\d+)$"
names(scale)[grep(reg, names(scale))] <- 
  sprintf("V%02d", as.numeric(gsub(reg, sprintf("\\1"), names(scale)[grep(reg, names(scale))])))


set.seed(1205)

f <- as.matrix(dplyr::select(scale, starts_with("V")))~Time

M0 <- llply(1:4, function(k) poLCA(f,scale,nclass=k, nrep=50, graphs=TRUE))
M0_fit <- ldply(M0, function(fit) with(fit, c(loglik=llik, AIC=aic, BIC=bic)))

M0_classmeans <- ldply(M0, function(M) ldply(M$probs, function(p) colSums((1:ncol(p))*t(p))))
#M0_classmeans <- ldply(M0, function(M) ldply(M$probs, function(p) apply(p, 1, function(pp) which(pp == max(pp)))))

expected_value <- melt(M0_classmeans)
solution_names <- c("1. One-class","2. Two-class","3. Three-class","4. Four-class")
expected_value$solution <- solution_names[rep(rep(1:4, each=10), 4)]

names(expected_value) <- c("Variable", "Class", "Expected value", "Solution")
levels(expected_value$Class) <- as.character(seq_along(levels(expected_value$Class)))

pl <- ggplot(expected_value, aes(Variable, `Expected value`, colour=Class, shape=Class))
pl +  geom_point() + facet_wrap(~Solution) +  geom_line(aes(colour = Class, group = Class)) + 
  theme_bw() +   geom_dl(aes(label=Class), list(dl.trans(x=x+0.2), "last.qp", cex=1))  + guides(colour=FALSE, shape=FALSE)

ggsave("~/Dropbox/HCI-book-chapter/poLCA-solution.pdf")
#Saving 8.38 x 4.65 in image

scale$PredictedClass_2 <- M0[[2]]$predclass
scale$PredictedClass_4 <- M0[[4]]$predclass

options(digits=2)
dlply(scale, .(PredictedClass_4), function(x) cor(x[,grep("^V\\d+$", names(x))]))
with(scale, cor(SUS3, SUS4))
with(subset(scale, PredictedClass_4==4), cor(SUS3, SUS4))

set.seed(99)

pdf("~/Dropbox/HCI-book-chapter/scatter_all.pdf", width=8.7, height=6)
with(scale, { 
  plot(jitter(V01), jitter(V10), axes=FALSE, main=sprintf("All data (cor = %1.2f)", cor(V01, V10)),
       pch=PredictedClass_4)
  axis(1); axis(2)
  abline(lm(V10 ~ V01), col="gray")
})
dev.off()


pdf("~/Dropbox/HCI-book-chapter/scatter_separate.pdf", width=8.7, height=2.5)
par(mfrow=c(1, 4))
for(k in 1:4) {
  with(subset(scale, PredictedClass_4==k), {
    plot(jitter(V01), jitter(V10), axes=FALSE, xlim=c(1,6), ylim=c(1,6), 
         main=sprintf("Class %d (cor = %1.2f)", k, cor(V01, V10)), pch=k)
    abline(lm(V10 ~ V01), col="gray")
    axis(1); axis(2, las=2)
  }) 
}
dev.off()


library(lme4)
summary(lm(responseTime ~ Team, data = email))
summary(lmer(responseTime ~ (1|ID) + Team + as.factor(Time), data = email))

summary(glmer(responseTime ~ (1|ID) + Team + as.factor(Time), family=Gamma, data = email))

write.table(scale, "~/Dropbox/HCI-book-chapter/scale.dat", row.names=FALSE, sep="\t", quote=FALSE, na=".")


